/*===============================================================================================================*/
// ********************************** THESE ARE THE INFORMATIONS OF THE MAP: *********************************** //
/*===============================================================================================================*/
// NONE FOR NOW:
/*---------------------------------------------------------------------------------------------------------------*/

// RIVER PLATO:
// CREATED BY DANY:
// OCTOBER 2007:

/*===============================================================================================================*/
// ********************************* MAIN ENTRY POINT FOR RANDOM MAP SCRIPT: ********************************** //
/*==============================================================================================================*/

include "mercenaries.xs";
void main(void)
{
/*==============================================================================================================*/
   // TEXT:
   // THESE STATUS TEXT LINES ARE USED TO MANUALLY ANIMATE THE MAP GENERATION PROGRESS BAR:
   rmSetStatusText("",0.01);
/*===============================================================================================================*/

        int whichVariation = rmRandInt(1,2); 	 
   
/*==============================================================================================================*/
// ***************************************** PICKS THE MAP SIZE: ********************************************** //
/*==============================================================================================================*/

        int playerTiles=25000;		
        
		int size=2.0*sqrt(cNumberNonGaiaPlayers*playerTiles);
        rmEchoInfo("Map size="+size+"m x "+size+"m");
        rmSetMapSize(632, 632);
		
/*================================================================================================================*/
   // TEXT:
   // THESE STATUS TEXT LINES ARE USED TO MANUALLY ANIMATE THE MAP GENERATION PROGRESS BAR:
   rmSetStatusText("",0.05);
/*================================================================================================================*/   
// *************************************** DEFINE THE MAP PARAMETERS: ******************************************* //		
/*================================================================================================================*/	
// NONE FOR NOW:
/*----------------------------------------------------------------------------------------------------------------*/
	
	    // SET MAP ELEVATION PARAMETERS:
		rmSetMapElevationParameters(cElevTurbulence, 0.05, 6, 0.7, 8.0);  
	
	    // SET MAP ELEVATION HEIGHT BLEND:
		rmSetMapElevationHeightBlend(1);
		
		// PICKS A DEFAULT WATER HEIGHT:
        rmSetSeaLevel(3.0);

        // SET SEA TYPE:
		rmSetSeaType("yucatan Coast");
	    
		// ENABLE LOCAL WATER:
		rmEnableLocalWater(false);		

	    // PICKS DEFAULT TERRAIN AND WATER:
	    rmSetBaseTerrainMix("amazon grass");
		rmTerrainInitialize("amazon\ground2_ama", 5);
	    
		// SET MAP TYPE:
		rmSetMapType("yucatan");
	    rmSetMapType("tropical");
	    rmSetMapType("water");
    
		// SET LIGHTING:
		rmSetLightingSet("amazon");

	    // MAKE THE CORNERS:
	    rmSetWorldCircleConstraint(true);

	    // CHOOSE MERCS:
	    chooseMercs();
	
/*================================================================================================================*/
   // TEXT:
   // THESE STATUS TEXT LINES ARE USED TO MANUALLY ANIMATE THE MAP GENERATION PROGRESS BAR:
   rmSetStatusText("",0.10);
/*================================================================================================================*/
// **************************************** SET UP THE NATIVE TRIBES: ******************************************* //
/*================================================================================================================*/
// NONE FOR NOW:
/*----------------------------------------------------------------------------------------------------------------*/
    
	    // THIS MENU GIVES YOU THE CHOICE OF 5 DIFFERENT TYPE OF NATIVE TRIBES:
		// BUT ALSO ONLY 4 NATIVE TRIBES:
		
		int whichNative = rmRandInt(1,5);
        int subCiv0 = -1; // THE FIRST NATIVE TRIBE:
        int subCiv1 = -1; // THE SECOND NATIVE TRIBE:
		int subCiv2 = -1; // THE THIRD NATIVE TRIBE:
		int subCiv3 = -1; // THE FOURTH NATIVE TRIBE:
        string nativeName = "";

	    if (whichNative == 1) // THE FIRST CHOICE:
	{
        subCiv0 = rmGetCivID("Tupi");
        rmEchoInfo("subCiv0 is Tupi "+subCiv0);
        subCiv1 = rmGetCivID("Tupi");
        rmEchoInfo("subCiv1 is Tupi "+subCiv1);
		subCiv2 = rmGetCivID("Tupi");
        rmEchoInfo("subCiv2 is Tupi "+subCiv2);
		subCiv3 = rmGetCivID("Tupi");
        rmEchoInfo("subCiv3 is Tupi "+subCiv3);
        rmSetSubCiv(0, "tupi", true);
        rmSetSubCiv(1, "Tupi", true);
		rmSetSubCiv(2, "Tupi", true);
        rmSetSubCiv(3, "Tupi", true);
        nativeName = "native tupi village ";
	}
	    else if (whichNative == 2) // THE SECOND CHOICE:
	{
        subCiv0 = rmGetCivID("Aztecs");
        rmEchoInfo("subCiv0 is Aztecs "+subCiv0);
        subCiv1 = rmGetCivID("Aztecs");
        rmEchoInfo("subCiv1 is Aztecs "+subCiv1);
		subCiv2 = rmGetCivID("Aztecs");
        rmEchoInfo("subCiv2 is Aztecs "+subCiv2);
        subCiv3 = rmGetCivID("Aztecs");
        rmEchoInfo("subCiv3 is Aztecs "+subCiv3);
        rmSetSubCiv(0, "Aztecs", true);
        rmSetSubCiv(1, "Aztecs", true);
		rmSetSubCiv(2, "Aztecs", true);
        rmSetSubCiv(3, "Aztecs", true);
        nativeName = "native aztec village ";
   }
        else if (whichNative == 3) // THE THIRD CHOICE:
	{
        subCiv0 = rmGetCivID("Incas");
        rmEchoInfo("subCiv0 is Incas "+subCiv0);
        subCiv1 = rmGetCivID("Incas");
        rmEchoInfo("subCiv1 is Incas "+subCiv1);
		subCiv2 = rmGetCivID("Incas");
        rmEchoInfo("subCiv2 is Incas "+subCiv2);
        subCiv3 = rmGetCivID("Incas");
        rmEchoInfo("subCiv3 is Incas "+subCiv3);
        rmSetSubCiv(0, "Incas", true);
        rmSetSubCiv(1, "Incas", true);
		rmSetSubCiv(2, "Incas", true);
        rmSetSubCiv(3, "Incas", true);
        nativeName = "native Inca village ";
   }
        else if (whichNative == 4) // THE FOURTH CHOICE:
	{
        subCiv0 = rmGetCivID("Caribs");
        rmEchoInfo("subCiv0 is Caribs "+subCiv0);
        subCiv1 = rmGetCivID("Caribs");
        rmEchoInfo("subCiv1 is Caribs "+subCiv1);
		subCiv2 = rmGetCivID("Caribs");
        rmEchoInfo("subCiv2 is Caribs "+subCiv2);
        subCiv3 = rmGetCivID("Caribs");
        rmEchoInfo("subCiv3 is Caribs "+subCiv3);
        rmSetSubCiv(0, "Caribs", true);
        rmSetSubCiv(1, "Caribs", true);
		rmSetSubCiv(2, "Caribs", true);
        rmSetSubCiv(3, "Caribs", true);
        nativeName = "native carib village ";
   }
   
   
        else // THE FITH CHOICE:
   {
        subCiv0 = rmGetCivID("Maya");
        rmEchoInfo("subCiv0 is Maya "+subCiv0);
        subCiv1 = rmGetCivID("Maya");
        rmEchoInfo("subCiv1 is Maya "+subCiv1);
		subCiv2 = rmGetCivID("Maya");
        rmEchoInfo("subCiv2 is Maya "+subCiv2);
        subCiv3 = rmGetCivID("Maya");
        rmEchoInfo("subCiv3 is Maya "+subCiv3);
        rmSetSubCiv(0, "Maya", true);
        rmSetSubCiv(1, "Maya", true);
		rmSetSubCiv(2, "Maya", true);
        rmSetSubCiv(3, "Maya", true);
        nativeName = "native maya village ";
   }
   
/*================================================================================================================*/
   // TEXT:
   // THESE STATUS TEXT LINES ARE USED TO MANUALLY ANIMATE THE MAP GENERATION PROGRESS BAR:
   rmSetStatusText("",0.15);
/*================================================================================================================*/
// ************************* DEFINE SOME CLASSES: THESE ARE USED LATER FOR CONSTRAINTS: ************************* //
/*================================================================================================================*/
// NONE FOR NOW:
/*----------------------------------------------------------------------------------------------------------------*/
    
		int classPlayer=rmDefineClass("player");
        rmDefineClass("classHill");
        rmDefineClass("classPatch");
        rmDefineClass("starting settlement");
        rmDefineClass("startingUnit");
        rmDefineClass("classForest");
        rmDefineClass("importantItem");
        rmDefineClass("natives");
	    rmDefineClass("classCliff");
	    rmDefineClass("classMountain");
		rmDefineClass("classSocket");
		rmDefineClass("classTrees");

	    int classCliff = rmDefineClass("Cliffs");
	
/*==============================================================================================================*/
   // TEXT:
   // THESE STATUS TEXT LINES ARE USED TO MANUALLY ANIMATE THE MAP GENERATION PROGRESS BAR:
   rmSetStatusText("",0.20);
/*==============================================================================================================*/   
// ****************************************** DEFINE THE CONSTRAINTS: ***************************************** //
// ************************ THESE ARE USED TO HAVE OBJECTS AND AREAS AVOID EACH OTHER: ************************ //
/*==============================================================================================================*/
// NONE FOR NOW:
/*----------------------------------------------------------------------------------------------------------------*/
   
    // MAP EDGE CONSTRAINTS:
    //int playerEdgeConstraint=rmCreateBoxConstraint("player edge of map", rmXTilesToFraction(6), rmZTilesToFraction(6), 1.0-rmXTilesToFraction(6), 1.0-rmZTilesToFraction(6), 0.01);
	int playerEdgeConstraint=rmCreatePieConstraint("player edge of map", 0.5, 0.5, rmXFractionToMeters(0.0), rmXFractionToMeters(0.475), rmDegreesToRadians(0), rmDegreesToRadians(360));
	int coinEdgeConstraint=rmCreateBoxConstraint("coin edge of map", rmXTilesToFraction(19), rmZTilesToFraction(19), 1.0-rmXTilesToFraction(19), 1.0-rmZTilesToFraction(19), 2.0);

    // CARDINAL DIRECTIONS:
	int Eastward=rmCreatePieConstraint("eastMapConstraint", 0.5, 0.5, 0, rmZFractionToMeters(0.5), rmDegreesToRadians(45), rmDegreesToRadians(225));
	int Westward=rmCreatePieConstraint("westMapConstraint", 0.5, 0.5, 0, rmZFractionToMeters(0.5), rmDegreesToRadians(225), rmDegreesToRadians(45));
	int Southward=rmCreatePieConstraint("southMapConstraint", 0.5, 0.5, 0, rmZFractionToMeters(0.5), rmDegreesToRadians(140), rmDegreesToRadians(310));
	int Northward=rmCreatePieConstraint("northMapConstraint", 0.5, 0.5, 0, rmZFractionToMeters(0.5), rmDegreesToRadians(320), rmDegreesToRadians(130));

	// FISHES AVOIDANCE:
	int fishVsFishID=rmCreateTypeDistanceConstraint("fish v fish", "FishBass", 18.0);
    int fishLand = rmCreateTerrainDistanceConstraint("fish land", "land", true, 6.0);
	
	// WHALES AVOIDANCE:
	int whaleVsWhaleID=rmCreateTypeDistanceConstraint("whale v whale", "beluga", 15.0);
    int whaleLand = rmCreateTerrainDistanceConstraint("whale v. land", "land", true, 15.0);
	
	// NEW EXTRA STUFF FOR WATER SPAWN POINT AVOIDANCE:
	//int flagLand = rmCreateTerrainDistanceConstraint("flag vs land", "land", true, 20.0);
	//int flagVsFlag = rmCreateTypeDistanceConstraint("flag avoid same", "HomeCityWaterSpawnFlag", 15);
	
	// NEW EXTRA STUFF FOR WATER SPAWN POINT AVOIDANCE:
	int flagLand = rmCreateTerrainDistanceConstraint("flag vs land", "land", true, 20.0);
	int flagVsFlag = rmCreateTypeDistanceConstraint("flag avoid same", "HomeCityWaterSpawnFlag", 15);
	
	// NEW EXTRA STUFF FOR WATER SPAWN POINT AVOIDANCE:
	//int flagLand = rmCreateTerrainDistanceConstraint("flag vs land", "land", true, 20.0);
	//int flagVsFlag = rmCreateTypeDistanceConstraint("flag avoid same", "HomeCityWaterSpawnFlag", 15);
		
	// PLAYER CONSTRAINTS:
	int playerConstraint=rmCreateClassDistanceConstraint("avoid players", classPlayer, 15.0);
	int playerCloseConstraint=rmCreateClassDistanceConstraint("close avoid players", classPlayer, 8.0);
	
	int longPlayerConstraint=rmCreateClassDistanceConstraint("stay far away from players", classPlayer, 50.0);
 
    // FORESTS AVOIDANCE:
	int avoidForest=rmCreateClassDistanceConstraint("forest avoids forest", rmClassID("classForest"), 15.0);
	int avoidCloseForest=rmCreateClassDistanceConstraint("close avoids forest", rmClassID("classForest"), 8.0);
	int avoidMediumForest=rmCreateClassDistanceConstraint("medium avoids forest", rmClassID("classForest"), 30.0);
	
	int avoidForestFar=rmCreateClassDistanceConstraint("forest avoids forest far", rmClassID("classForest"), 40.0);
	
	// TREES AVOIDANCE:
	int avoidTrees=rmCreateClassDistanceConstraint("stuff avoid Trees", rmClassID("classTrees"), 10.0);
	int avoidCloseTrees=rmCreateClassDistanceConstraint("close avoid Trees", rmClassID("classTrees"), 5.0);
	int avoidVeryCloseTrees=rmCreateClassDistanceConstraint("very close avoid Trees", rmClassID("classTrees"), 2.0);
	int avoidMediumTrees=rmCreateClassDistanceConstraint("medium avoid Trees", rmClassID("classTrees"), 25.0);
	int avoidFarTrees=rmCreateClassDistanceConstraint("far avoid Trees", rmClassID("classTrees"), 50.0);
	int avoidVeryFarTrees=rmCreateClassDistanceConstraint("very far avoid Trees", rmClassID("classTrees"), 75.0);
	
	// TURKEY AVOIDANCE:
	int avoidturkey=rmCreateTypeDistanceConstraint("avoids turkey", "turkey", 45.0);
	
	// SHEEP AVOIDANCE:
	int avoidSheep=rmCreateTypeDistanceConstraint("avoids sheep", "sheep", 15.0);
	int avoidCloseSheep=rmCreateTypeDistanceConstraint("close avoids sheep", "sheep", 8.0);
	int avoidVeryFarSheep=rmCreateTypeDistanceConstraint("very far avoids sheep", "sheep", 75.0);
	
	// FRUITS AVOIDANCE:
	int avoidFruits=rmCreateTypeDistanceConstraint("avoid fruits", "berrybush", 15.0);
	int avoidCloseFruits=rmCreateTypeDistanceConstraint("close avoid fruits", "berrybush", 8.0);
	int avoidFarFruits=rmCreateTypeDistanceConstraint("far avoid fruits", "berrybush", 50.0);
	int avoidVeryFarFruits=rmCreateTypeDistanceConstraint("very far avoid fruits", "berrybush", 75.0);
	
	// DEER AVOIDANCE:
	int avoidDeer=rmCreateTypeDistanceConstraint("deer avoids deer", "deer", 15.0);
	int avoidCloseDeer=rmCreateTypeDistanceConstraint("close avoids deer", "deer", 8.0);
	int avoidMediumDeer=rmCreateTypeDistanceConstraint("medium avoids deer", "deer", 25.0);
	int avoidVeryFarDeer=rmCreateTypeDistanceConstraint("very far avoids deer", "deer", 75.0);
	int avoiddeerFar=rmCreateTypeDistanceConstraint("deer avoids deer Far", "deer", 65.0);
	
	// COIN AVOIDANCE:
	int avoidCoin=rmCreateTypeDistanceConstraint("avoid coin", "gold", 15.0);
	int avoidCloseCoin=rmCreateTypeDistanceConstraint("close avoid coin", "gold", 8.0);
	int avoidMediumCoin=rmCreateTypeDistanceConstraint("medium avoid coin", "gold", 25.0);
	int avoidVeryFarCoin=rmCreateTypeDistanceConstraint("very far avoid coin", "gold", 75.0);
	int avoidCoinFar=rmCreateTypeDistanceConstraint("avoid coin far", "gold", 60.0);
   
    // AVOID IMPASSABLE LAND:
	int avoidImpassableLand = rmCreateTerrainDistanceConstraint("avoid impassable land", "Land", false, 15.0);
	int avoidCloseImpassableLand = rmCreateTerrainDistanceConstraint("close avoid impassable land", "Land", false, 8.0);
	
	// CLIFFS AVOIDANCE:
		
	int avoidCliffs=rmCreateClassDistanceConstraint("stuff vs. cliff", rmClassID("classCliff"), 15.0);
	int avoidCloseCliffs=rmCreateClassDistanceConstraint("close stuff vs. cliff", rmClassID("classCliff"), 5.0);
	int avoidVeryCloseCliffs=rmCreateClassDistanceConstraint("very close stuff vs. cliff", rmClassID("classCliff"), 2.0);
	int avoidMediumCliffs=rmCreateClassDistanceConstraint("medium stuff vs. cliff", rmClassID("classCliff"), 25.0);
	int avoidFarCliffs=rmCreateClassDistanceConstraint("far stuff vs. cliff", rmClassID("classCliff"), 50.0);
	int avoidVeryFarCliffs=rmCreateClassDistanceConstraint("very far stuff vs. cliff", rmClassID("classCliff"), 75.0);
	
	// IMPASSABLE LAND AVOIDANCE:
	int mediumShortAvoidImpassableLand = rmCreateTerrainDistanceConstraint("mediumshort avoid impassable land", "Land", false, 10.0);
	int shortAvoidImpassableLand = rmCreateTerrainDistanceConstraint("short avoid impassable land", "Land", false, 2.0);
	int mediumAvoidImpassableLand = rmCreateTerrainDistanceConstraint("medium avoid impassable land", "Land", false, 12.0);
	int longAvoidImpassableLand = rmCreateTerrainDistanceConstraint("long avoid impassable land", "Land", false, 20.0);

    // UNIT AVOIDANCE:
	int avoidHuari=rmCreateTypeDistanceConstraint("avoid Huari", "huariStronghold", 20.0);
	
	// TOWNCENTER AVOIDANCE:
	int avoidTownCenter=rmCreateTypeDistanceConstraint("avoid Town Center", "townCenter", 20.0);
	int avoidTownCenterFar=rmCreateTypeDistanceConstraint("avoid Town Center Far", "townCenter", 40.0);
	int avoidTownCenterSupaFar=rmCreateTypeDistanceConstraint("avoid Town Center Supa Far", "townCenter", 50.0);
    
	// IMPORTANT ITEM AVOIDANCE:
	int avoidImportantItem=rmCreateClassDistanceConstraint("secrets etc avoid each other", rmClassID("importantItem"), 60.0);
    int shortAvoidImportantItem=rmCreateClassDistanceConstraint("secrets etc avoid each other by a bit", rmClassID("importantItem"), 10.0);
    
	// NATIVES AVOIDANCE:
	int avoidNatives=rmCreateClassDistanceConstraint("stuff avoids natives", rmClassID("natives"), 15.0);
    int avoidCloseNatives=rmCreateClassDistanceConstraint("close avoids natives", rmClassID("natives"), 8.0);
    int avoidNativesFar=rmCreateClassDistanceConstraint("stuff avoids natives far", rmClassID("natives"), 45.0);
	
	// NUGGETS AVOIDANCE:
	int avoidNugget=rmCreateTypeDistanceConstraint("nugget avoid nugget", "AbstractNugget", 15.0);
	int avoidCloseNugget=rmCreateTypeDistanceConstraint("close avoid nugget", "AbstractNugget", 8.0);
	int avoidFarNugget=rmCreateTypeDistanceConstraint("far avoid nugget", "AbstractNugget", 50.0);
	int avoidVeryFarNugget=rmCreateTypeDistanceConstraint("very far avoid nugget", "AbstractNugget", 75.0);
	
	// WATER AVOIDANCE:
	int avoidWater4 = rmCreateTerrainDistanceConstraint("avoid water", "Land", false, 4.0);
    int avoidWater8 = rmCreateTerrainDistanceConstraint("avoid water medium 8", "Land", false, 8.0);
    int avoidWater10 = rmCreateTerrainDistanceConstraint("avoid water medium 10", "Land", false, 10.0);
    int avoidWater12 = rmCreateTerrainDistanceConstraint("avoid water medium 12", "Land", false, 12.0);
    int avoidWater15 = rmCreateTerrainDistanceConstraint("avoid water medium 15", "Land", false, 15.0);
    int avoidWater20 = rmCreateTerrainDistanceConstraint("avoid water long", "Land", false, 20.0);
	
    // DECORATION AVOIDANCE:
    int avoidAll=rmCreateTypeDistanceConstraint("avoid all", "all", 8.0);
	
	// SOCKETS AVOIDANCE:
	int avoidSocket=rmCreateTypeDistanceConstraint("avoid socket", "socket", 15);
	int avoidCloseSocket=rmCreateTypeDistanceConstraint("close avoid socket", "socket", 8);
	
	// TRADE ROUTE AVOIDANCE:
    int avoidTradeRoute = rmCreateTradeRouteDistanceConstraint("trade route", 15.0);
	int avoidCloseTradeRoute = rmCreateTradeRouteDistanceConstraint("close trade route", 8.0);
	
/*===============================================================================================================*/
   // TEXT:
   // THESE STATUS TEXT LINES ARE USED TO MANUALLY ANIMATE THE MAP GENERATION PROGRESS BAR:
   rmSetStatusText("",0.25);
/*================================================================================================================*/   
// ******************************************* DEFINE SOME OBJECTS: ******************************************** //
// ************************* THESE OBJECTS ARE ALL DEFINED SO THEY CAN BE PLACED LATER: ************************ //
/*================================================================================================================*/
// NONE FOR NOW:
/*----------------------------------------------------------------------------------------------------------------*/
	    
		//int startingUnits = rmCreateStartingUnitsObjectDef(5.0);
		
/*================================================================================================================*/
// ***************************** DEFINE AND PLACE THE TRADE ROUTE AND THE SOCKETS: ****************************** //
/*================================================================================================================*/
// NONE FOR NOW:
/*----------------------------------------------------------------------------------------------------------------*/

        // CLEAR OUT CONSTRAINS FOR GOOD MEASURE:
        rmClearClosestPointConstraints();
   
/*----------------------------------------------------------------------------------------------------------------*/   

	    // SOCKET DEFINITION:
	    int socketID=rmCreateObjectDef("sockets to dock Trade Posts");
	    rmAddObjectDefItem(socketID, "SocketTradeRoute", 1, 0.0);
	    rmSetObjectDefAllowOverlap(socketID, true);
		rmAddObjectDefToClass(socketID, rmClassID("classSocket"));
	    rmSetObjectDefMinDistance(socketID, 0.0);
	    rmSetObjectDefMaxDistance(socketID, 8.0);
		
/*----------------------------------------------------------------------------------------------------------------*/		

	    // TRADE ROUTE 1:
		int tradeRoute1ID = rmCreateTradeRoute();
	    rmAddTradeRouteWaypoint(tradeRoute1ID, 0.425, 0.725);
		rmAddTradeRouteWaypoint(tradeRoute1ID, 0.725, 0.725);
		rmAddTradeRouteWaypoint(tradeRoute1ID, 0.725, 0.425);
	
	    bool placedTradeRoute1 = rmBuildTradeRoute(tradeRoute1ID, "dirt");
	    if(placedTradeRoute1 == false)
		rmEchoError("Failed to place trade route one");

	    // ADD THE MEETING SOCKETS ALONG THE TRADE ROUTE:
	    rmSetObjectDefTradeRouteID(socketID, tradeRoute1ID);
	    vector socketLoc1 = rmGetTradeRouteWayPoint(tradeRoute1ID, 0.05);
	    rmPlaceObjectDefAtPoint(socketID, 0, socketLoc1);

	    socketLoc1 = rmGetTradeRouteWayPoint(tradeRoute1ID, 0.50);
	    rmPlaceObjectDefAtPoint(socketID, 0, socketLoc1);
		
		socketLoc1 = rmGetTradeRouteWayPoint(tradeRoute1ID, 0.95);
	    rmPlaceObjectDefAtPoint(socketID, 0, socketLoc1);
		
/*----------------------------------------------------------------------------------------------------------------*/		

	    // TRADE ROUTE 2:
		int tradeRoute2ID = rmCreateTradeRoute();
	    rmAddTradeRouteWaypoint(tradeRoute2ID, 0.275, 0.575);
		rmAddTradeRouteWaypoint(tradeRoute2ID, 0.275, 0.275);
		rmAddTradeRouteWaypoint(tradeRoute2ID, 0.575, 0.275);

	    bool placedTradeRoute2 = rmBuildTradeRoute(tradeRoute2ID, "dirt");
	    if(placedTradeRoute2 == false)
		rmEchoError("Failed to place trade route 2");

	    // ADD THE MEETING SOCKETS ALONG THE TRADE ROUTE:
	    rmSetObjectDefTradeRouteID(socketID, tradeRoute2ID);
	    vector socketLoc2 = rmGetTradeRouteWayPoint(tradeRoute2ID, 0.05);
	    rmPlaceObjectDefAtPoint(socketID, 0, socketLoc2);
	
    	socketLoc2 = rmGetTradeRouteWayPoint(tradeRoute2ID, 0.50);
	    rmPlaceObjectDefAtPoint(socketID, 0, socketLoc2);

	    socketLoc2 = rmGetTradeRouteWayPoint(tradeRoute2ID, 0.95);
	    rmPlaceObjectDefAtPoint(socketID, 0, socketLoc2);

/*===============================================================================================================*/
   // TEXT:
   // THESE STATUS TEXT LINES ARE USED TO MANUALLY ANIMATE THE MAP GENERATION PROGRESS BAR:
   rmSetStatusText("",0.30);
/*================================================================================================================*/   
// *********************************** SET UP THE LOCATIONS OF THE PLAYERS: ************************************* //
/*================================================================================================================*/

        if ( whichVariation == 1 )
	
	{	
		rmSetPlacementTeam(0);
		rmSetTeamSpacingModifier(0.20);
		rmPlacePlayersLine(0.1, 0.5, 0.5, 0.1, 0, 0.0);

		rmSetPlacementTeam(1);
		rmSetTeamSpacingModifier(0.20);
		rmPlacePlayersLine(0.9, 0.5, 0.5, 0.9, 0, 0.0);
	}
	    else
	
	{	
	    rmSetPlacementTeam(0);
		rmSetTeamSpacingModifier(0.20);
		rmPlacePlayersLine(0.9, 0.5, 0.5, 0.9, 0, 0.0);
		
		rmSetPlacementTeam(1);
		rmSetTeamSpacingModifier(0.20);
		rmPlacePlayersLine(0.1, 0.5, 0.5, 0.1, 0, 0.0);
	}
	
/*===============================================================================================================*/
   // TEXT:
   // THESE STATUS TEXT LINES ARE USED TO MANUALLY ANIMATE THE MAP GENERATION PROGRESS BAR:
   rmSetStatusText("",0.35);
/*================================================================================================================*/   
// *********************************** DEFINE AND PLACE THE CENTRAL RIVER: ************************************** //
/*================================================================================================================*/
   
	    int amazonRiver = rmRiverCreate(-1, "yucatan Coast", 2, 2, 20, 20);
	
		rmRiverSetConnections(amazonRiver, 0.15, 0.85, 0.85, 0.15);
   
        rmRiverSetShallowRadius(amazonRiver, 15);
        rmRiverAddShallow(amazonRiver, rmRandFloat(0.5, 0.5));
        //rmRiverAddShallow(amazonRiver, rmRandFloat(0.8, 0.8));
    
		rmRiverSetBankNoiseParams(amazonRiver, 0.07, 2, 1.5, 20.0, 0.667, 2.0);
        rmRiverBuild(amazonRiver);
        //rmRiverReveal(amazonRiver, 2); 			
	
/*===============================================================================================================*/
   // TEXT:
   // THESE STATUS TEXT LINES ARE USED TO MANUALLY ANIMATE THE MAP GENERATION PROGRESS BAR:
   rmSetStatusText("",0.40);
/*================================================================================================================*/   
// **************************************** SET UP THE PLAYER AREAS: ******************************************** //   
/*================================================================================================================*/
    
        float playerFraction=rmAreaTilesToFraction(1750);
    
		for(i=1; <cNumberPlayers)
   {
        // CREATE THE AREA:
        int id=rmCreateArea("Player"+i);
    
		// ASSIGN TO THE PLAYER:
        rmSetPlayerArea(i, id);
    
		// SET THE SIZE:
        rmSetAreaSize(id, playerFraction, playerFraction);
    
		// ADD AREA TO CLASS:
		rmAddAreaToClass(id, classPlayer);
    
		// SET AREA MIN AND MAX:
		rmSetAreaMinBlobs(id, 1);
        rmSetAreaMaxBlobs(id, 1);
    
		// ADD AREA CONSTRAINT:
		rmAddAreaConstraint(id, playerConstraint); 
        //rmAddAreaConstraint(id, playerEdgeConstraint);
    
		// SET AREA LOC PLAYER:
		rmSetAreaLocPlayer(id, i);
    
		// SET AREA TERRAIN TYPE:
		//rmSetAreaTerrainType(id, "carolina\marshflats");
	
		// SET AREA COHERENCE:
		rmSetAreaCoherence(id, 1.0);
	
		// SET AREA MIX:
		//rmSetAreaMix(id, "rockies_snow");
	
		// SET AREA TERRAIN TYPE:
		//rmSetAreaTerrainType(id, "rockies\groundsnow1_roc");
	
		// SET AREA TERRAIN TYPE:
		//rmSetAreaTerrainType(id, "texas\ground2");
    
		// SET AREA BASE HEIGHT:
		//rmSetAreaBaseHeight(id, 18.0);
    
		// SET AREA WARN FAILURE:
		rmSetAreaWarnFailure(id, false);
   }
        // BUILD THE AREAS:
        rmBuildAllAreas();
   
/*================================================================================================================*/
   // TEXT:
   // THESE STATUS TEXT LINES ARE USED TO MANUALLY ANIMATE THE MAP GENERATION PROGRESS BAR:
   rmSetStatusText("",0.45);
/*================================================================================================================*/   

        // THESE ARE VARIABLES TO BE USED LATER:
		int failCount = -1;
        int numTries = cNumberNonGaiaPlayers+2;
	
/*================================================================================================================*/
   // TEXT:
   // THESE STATUS TEXT LINES ARE USED TO MANUALLY ANIMATE THE MAP GENERATION PROGRESS BAR:
   rmSetStatusText("",0.50);
/*================================================================================================================*/		
// ************************************ DEFINE AND PLACE THE NATIVE TRIBES: ************************************* //		
/*================================================================================================================*/
 
        int nativeVillageA = 0;
        int nativeVillageTypeA = rmRandInt(1,5);
      
        nativeVillageA = rmCreateGrouping("Native village A "+i, nativeName+nativeVillageTypeA);
        rmSetGroupingMinDistance(nativeVillageA, 0.0);
        rmSetGroupingMaxDistance(nativeVillageA, 20.0);
        rmAddGroupingConstraint(nativeVillageA, avoidImpassableLand);
        rmAddGroupingToClass(nativeVillageA, rmClassID("natives"));
        rmAddGroupingToClass(nativeVillageA, rmClassID("importantItem"));
        
		rmPlaceGroupingAtLoc(nativeVillageA, 0, 0.20, 0.20);
    
/*----------------------------------------------------------------------------------------------------------------*/
	
        int nativeVillageB = 0;
        int nativeVillageTypeB = rmRandInt(1,5);

        nativeVillageB = rmCreateGrouping("Native village B "+i, nativeName+nativeVillageTypeB);
        rmSetGroupingMinDistance(nativeVillageB, 0.0);
        rmSetGroupingMaxDistance(nativeVillageB, 20.0);
        rmAddGroupingConstraint(nativeVillageB, avoidImpassableLand);
        rmAddGroupingToClass(nativeVillageB, rmClassID("natives"));
        rmAddGroupingToClass(nativeVillageB, rmClassID("importantItem"));
      
	    rmPlaceGroupingAtLoc(nativeVillageB, 0, 0.40, 0.40);
		
/*----------------------------------------------------------------------------------------------------------------*/

        int nativeVillageC = 0;
        int nativeVillageTypeC = rmRandInt(1,5);

        nativeVillageC = rmCreateGrouping("Native village C "+i, nativeName+nativeVillageTypeC);
        rmSetGroupingMinDistance(nativeVillageC, 0.0);
        rmSetGroupingMaxDistance(nativeVillageC, 20.0);
        rmAddGroupingConstraint(nativeVillageC, avoidImpassableLand);
        rmAddGroupingToClass(nativeVillageC, rmClassID("natives"));
        rmAddGroupingToClass(nativeVillageC, rmClassID("importantItem"));
      
	    rmPlaceGroupingAtLoc(nativeVillageC, 0, 0.60, 0.60);

/*----------------------------------------------------------------------------------------------------------------*/

        int nativeVillageD = 0;
        int nativeVillageTypeD = rmRandInt(1,5);

        nativeVillageD = rmCreateGrouping("Native village D "+i, nativeName+nativeVillageTypeD);
        rmSetGroupingMinDistance(nativeVillageD, 0.0);
        rmSetGroupingMaxDistance(nativeVillageD, 20.0);
        rmAddGroupingConstraint(nativeVillageD, avoidImpassableLand);
        rmAddGroupingToClass(nativeVillageD, rmClassID("natives"));
        rmAddGroupingToClass(nativeVillageD, rmClassID("importantItem"));
      
	    rmPlaceGroupingAtLoc(nativeVillageD, 0, 0.80, 0.80);		
    
/*================================================================================================================*/
   // TEXT:
   // THESE STATUS TEXT LINES ARE USED TO MANUALLY ANIMATE THE MAP GENERATION PROGRESS BAR:
   rmSetStatusText("",0.55);
/*================================================================================================================*/		
// ********************** DEFINE THE TCID AND THE STARTING UNITS AND THE PLAYER RESOURCES: ********************** //
/*================================================================================================================*/

	    // CLEAR CLOSEST POINTS CONSTRAINTS:
		rmClearClosestPointConstraints();
    
		// DEFINE THE VARIABLE TCFLOAT:
		int TCfloat = 0.0;
   
	    // DEFFINE THE TCID:
		int TCID = rmCreateObjectDef("Player TC");

	    if (rmGetNomadStart())
	{
		rmAddObjectDefItem(TCID, "CoveredWagon", 1, 0.0);
	}
	    else
	{
		rmAddObjectDefItem(TCID, "TownCenter", 1, 0.0);
	}
	    rmSetObjectDefMinDistance(TCID, 0.0);
	    rmSetObjectDefMaxDistance(TCID, TCfloat);
		//rmSetObjectDefMaxDistance(TCID, 0.0);
	
/*----------------------------------------------------------------------------------------------------------------*/		
	
		// DEFINE THE STARTING UNITS:
		int startingUnits = rmCreateStartingUnitsObjectDef(5.0);
	    rmSetObjectDefMinDistance(startingUnits, 5.0);
	    rmSetObjectDefMaxDistance(startingUnits, 10.0);
	    rmAddObjectDefToClass(startingUnits, rmClassID("startingUnit"));
	    rmAddObjectDefConstraint(startingUnits, avoidAll);
	
/*----------------------------------------------------------------------------------------------------------------*/		

	    // DEFINE THE PLAYER SILVER:
		int playerSilverID = rmCreateObjectDef("player mine");
	    rmAddObjectDefItem(playerSilverID, "mine", 1, 0);
	    rmAddObjectDefConstraint(playerSilverID, avoidTownCenter);
	    rmSetObjectDefMinDistance(playerSilverID, 15.0);
	    rmSetObjectDefMaxDistance(playerSilverID, 20.0);
        rmAddObjectDefConstraint(playerSilverID, avoidImpassableLand);
        rmAddObjectDefConstraint(playerSilverID, coinEdgeConstraint);
	
/*----------------------------------------------------------------------------------------------------------------*/		

	    // DEFINE THE PLAYER TURKEY:
		int playerturkeyID=rmCreateObjectDef("player turkey");
        rmAddObjectDefItem(playerturkeyID, "turkey", rmRandInt(8,10), 10.0);
        rmSetObjectDefMinDistance(playerturkeyID, 10);
        rmSetObjectDefMaxDistance(playerturkeyID, 18);
        rmAddObjectDefConstraint(playerturkeyID, avoidAll);
        rmAddObjectDefConstraint(playerturkeyID, avoidImpassableLand);
        rmAddObjectDefConstraint(playerturkeyID, avoidCliffs);
        rmSetObjectDefCreateHerd(playerturkeyID, true);
		
/*----------------------------------------------------------------------------------------------------------------*/

        // DEFINE THE PLAYER BERRYBUSH:
		int playerberryID=rmCreateObjectDef("player berry");
        rmAddObjectDefItem(playerberryID, "berrybush", rmRandInt(3,5), 6.0);
        rmSetObjectDefMinDistance(playerberryID, 16);
        rmSetObjectDefMaxDistance(playerberryID, 22);
	    rmAddObjectDefConstraint(playerberryID, avoidAll);
        rmAddObjectDefConstraint(playerberryID, avoidImpassableLand);
	    rmAddObjectDefConstraint(playerberryID, avoidFruits);
        rmSetObjectDefCreateHerd(playerberryID, true);		
	
/*----------------------------------------------------------------------------------------------------------------*/		

	    // DEFINE THE PLAYER NUGGET:
		int playerNuggetID= rmCreateObjectDef("player nugget"); 
	    rmAddObjectDefItem(playerNuggetID, "Nugget", 1, 0.0);
	    rmSetNuggetDifficulty(1, 1);
	    rmAddObjectDefConstraint(playerNuggetID, avoidImpassableLand);
  	    rmAddObjectDefConstraint(playerNuggetID, avoidNugget);
  	    rmAddObjectDefConstraint(playerNuggetID, avoidAll);
	    rmAddObjectDefConstraint(playerNuggetID, avoidCliffs);
	    rmAddObjectDefConstraint(playerNuggetID, playerEdgeConstraint);
	    rmSetObjectDefMinDistance(playerNuggetID, 20.0);
	    rmSetObjectDefMaxDistance(playerNuggetID, 30.0);
	
/*---------------------------------------------------------------------------------------------------------------*/		

	    // DEFINE THE PLAYER TREE:
		int playerTreeID = rmCreateObjectDef("player trees");
        rmAddObjectDefItem(playerTreeID, "treeamazon", rmRandInt(5,10), 8.0);
        rmSetObjectDefMinDistance(playerTreeID, 15);
        rmSetObjectDefMaxDistance(playerTreeID, 20);
        rmAddObjectDefConstraint(playerTreeID, avoidAll);
        rmAddObjectDefConstraint(playerTreeID, avoidImpassableLand);
		
		
		int waterFlagID=rmCreateObjectDef("HC water flag "+i);
        rmAddObjectDefItem(waterFlagID, "HomeCityWaterSpawnFlag", 1, 0.0);
        rmAddClosestPointConstraint(flagVsFlag);
        rmAddClosestPointConstraint(flagLand);

/*================================================================================================================*/
   // TEXT:
   // THESE STATUS TEXT LINES ARE USED TO MANUALLY ANIMATE THE MAP GENERATION PROGRESS BAR:
   rmSetStatusText("",0.60);
/*================================================================================================================*/   
// ************************* PLACE THE TCID AND THE STARTING UNITS AND PLAYER RESOURCES: ************************ //
/*================================================================================================================*/   

	    for(i = 1; < cNumberPlayers)
   {
           
	    // PLACE THE TCID:
		rmPlaceObjectDefAtLoc(TCID, i, rmPlayerLocXFraction(i), rmPlayerLocZFraction(i));
	    vector TCLoc = rmGetUnitPosition(rmGetUnitPlacedOfPlayer(TCID, i));
	    vector closestPoint = rmFindClosestPointVector(TCLoc, rmXFractionToMeters(1.0));
		
		// PLACE THE STARTING UNITS:
		rmPlaceObjectDefAtLoc(startingUnits, i, rmXMetersToFraction(xsVectorGetX(TCLoc)), rmZMetersToFraction(xsVectorGetZ(TCLoc)));
	       
		// PLACE THE PLAYER RESOURCES:
		rmPlaceObjectDefAtLoc(playerSilverID, 0, rmXMetersToFraction(xsVectorGetX(TCLoc)), rmZMetersToFraction(xsVectorGetZ(TCLoc)));
	    rmPlaceObjectDefAtLoc(playerTreeID, 0, rmXMetersToFraction(xsVectorGetX(TCLoc)), rmZMetersToFraction(xsVectorGetZ(TCLoc)));
	    rmPlaceObjectDefAtLoc(playerturkeyID, 0, rmXMetersToFraction(xsVectorGetX(TCLoc)), rmZMetersToFraction(xsVectorGetZ(TCLoc)));
	    rmPlaceObjectDefAtLoc(playerberryID, 0, rmXMetersToFraction(xsVectorGetX(TCLoc)), rmZMetersToFraction(xsVectorGetZ(TCLoc)));
		rmPlaceObjectDefAtLoc(playerNuggetID, 0, rmXMetersToFraction(xsVectorGetX(TCLoc)), rmZMetersToFraction(xsVectorGetZ(TCLoc)));
    
		rmPlaceObjectDefAtLoc(waterFlagID, i, rmXMetersToFraction(xsVectorGetX(closestPoint)), rmZMetersToFraction(xsVectorGetZ(closestPoint)));
	
	    // CLEAR CLOSEST POINT CONSTRAINTS:
		//rmClearClosestPointConstraints();
	
   }
   
        // CLEAR CLOSEST POINT CONSTRAINTS:
		//rmClearClosestPointConstraints();
   
/*================================================================================================================*/
   // TEXT:
   // THESE STATUS TEXT LINES ARE USED TO MANUALLY ANIMATE THE MAP GENERATION PROGRESS BAR:
   rmSetStatusText("",0.65);
/*================================================================================================================*/
// ************************************* DEFINE AND PLACE THE FOREST AREAS: ************************************* //
/*================================================================================================================*/
// NONE FOR NOW:
/*----------------------------------------------------------------------------------------------------------------*/
        
	    // THE SOUTHERN FORESTS:
		int forestTreeID = 0;

	    if (cNumberNonGaiaPlayers <= 2)
		numTries=8*cNumberNonGaiaPlayers;
	    else
		numTries=4*cNumberNonGaiaPlayers;
	    
		failCount=0;
	    for (i=0; <numTries)
{   
		int forestID=rmCreateArea("forestID"+i);
		rmSetAreaWarnFailure(forestID, false);
		rmSetAreaSize(forestID, rmAreaTilesToFraction(160), rmAreaTilesToFraction(200));
		rmSetAreaForestType(forestID, "amazon rain forest");
		rmSetAreaForestDensity(forestID, 0.9);
		rmSetAreaForestClumpiness(forestID, 0.7);		
		rmSetAreaForestUnderbrush(forestID, 0.6);
		rmSetAreaMinBlobs(forestID, 1);
		rmSetAreaMaxBlobs(forestID, 4);						
		rmSetAreaMinBlobDistance(forestID, 5.0);
		rmSetAreaMaxBlobDistance(forestID, 20.0);
		rmSetAreaCoherence(forestID, 0.4);
		rmSetAreaSmoothDistance(forestID, 10);
		rmAddAreaToClass(forestID, rmClassID("classForest"));
		
		rmAddAreaConstraint(forestID, avoidMediumForest);  
		rmAddAreaConstraint(forestID, avoidTradeRoute);
		rmAddAreaConstraint(forestID, avoidImportantItem);
		rmAddAreaConstraint(forestID, playerEdgeConstraint);
		rmAddAreaConstraint(forestID, playerConstraint);
		rmAddAreaConstraint(forestID, avoidSocket);
		rmAddAreaConstraint(forestID, avoidAll);
		rmAddAreaConstraint(forestID, Southward);
		rmAddAreaConstraint(forestID, avoidWater12);
		
		if(rmBuildArea(forestID)==false)
	{
		// Stop trying once we fail 5 times in a row.
		failCount++;
		if(failCount==10)
		break;
	}
	    else
		failCount=0; 
	}
	
/*---------------------------------------------------------------------------------------------------------------*/

	    // THE NORTHERN FORESTS:
		int forestTreeNorthID = 0;
		
		if (cNumberNonGaiaPlayers <= 2)
		numTries=8*cNumberNonGaiaPlayers;
	    else
		numTries=4*cNumberNonGaiaPlayers;
	      
	    failCount=0;
	    for (i=0; <numTries)
	{   
		int forestnorthID=rmCreateArea("forestNorthID"+i);
		rmSetAreaWarnFailure(forestnorthID, false);
		rmSetAreaSize(forestnorthID, rmAreaTilesToFraction(160), rmAreaTilesToFraction(200));
		rmSetAreaForestType(forestnorthID, "amazon rain forest");
		rmSetAreaForestDensity(forestnorthID, 0.5);
		rmSetAreaForestClumpiness(forestnorthID, 0.4);		
		rmSetAreaForestUnderbrush(forestnorthID, 0.7);
		rmSetAreaMinBlobs(forestnorthID, 1);
		rmSetAreaMaxBlobs(forestnorthID, 4);						
		rmSetAreaMinBlobDistance(forestnorthID, 5.0);
		rmSetAreaMaxBlobDistance(forestnorthID, 20.0);
		rmSetAreaCoherence(forestnorthID, 0.4);
		rmSetAreaSmoothDistance(forestnorthID, 10);
		rmAddAreaToClass(forestnorthID, rmClassID("classForest"));
		
		rmAddAreaConstraint(forestnorthID, avoidMediumForest);  
		rmAddAreaConstraint(forestnorthID, avoidTradeRoute);
		rmAddAreaConstraint(forestnorthID, avoidSocket);
		rmAddAreaConstraint(forestnorthID, avoidImportantItem);
		rmAddAreaConstraint(forestnorthID, playerConstraint);
		rmAddAreaConstraint(forestnorthID, playerEdgeConstraint);
		rmAddAreaConstraint(forestnorthID, Northward);
		rmAddAreaConstraint(forestnorthID, avoidAll);
		rmAddAreaConstraint(forestnorthID, avoidWater12);
		
		if(rmBuildArea(forestnorthID)==false)
	{
		// Stop trying once we fail 5 times in a row.
		failCount++;
		if(failCount==10)
		break;
	}
	    else
		failCount=0; 
}

/*===============================================================================================================*/
   // TEXT:
   // THESE STATUS TEXT LINES ARE USED TO MANUALLY ANIMATE THE MAP GENERATION PROGRESS BAR:
   rmSetStatusText("",0.70);
/*================================================================================================================*/   
// *************************************** DEFINE AND PLACE THE NUGGETS: **************************************** //
/*================================================================================================================*/
// NONE FOR NOW:
/*----------------------------------------------------------------------------------------------------------------*/
 
	    // THE NORTHERN NUGGETS:
		int nuggetID= rmCreateObjectDef("The Nugget 1"); 
	    rmAddObjectDefItem(nuggetID, "Nugget", 1, 0.0);
	    rmSetObjectDefMinDistance(nuggetID, 0.0);
	    rmSetObjectDefMaxDistance(nuggetID, rmXFractionToMeters(0.5));
	    
		rmAddObjectDefConstraint(nuggetID, avoidImpassableLand);
  	    rmAddObjectDefConstraint(nuggetID, avoidVeryFarNugget);
  	    rmAddObjectDefConstraint(nuggetID, Northward);
		rmAddObjectDefConstraint(nuggetID, playerEdgeConstraint);
  	    rmAddObjectDefConstraint(nuggetID, avoidAll);
		rmAddObjectDefConstraint(nuggetID, avoidCloseNatives);
		rmAddObjectDefConstraint(nuggetID, avoidCloseTradeRoute);
		rmAddObjectDefConstraint(nuggetID, avoidCloseSocket);
		rmAddObjectDefConstraint(nuggetID, avoidForest);
  	    rmAddObjectDefConstraint(nuggetID, avoidWater15);
	    rmAddObjectDefConstraint(nuggetID, playerConstraint);
	    
		rmSetNuggetDifficulty(1, 2);
		if (cNumberNonGaiaPlayers<=2)
		rmPlaceObjectDefAtLoc(nuggetID, 0, 0.5, 0.5, 3*cNumberNonGaiaPlayers);
		else
		rmPlaceObjectDefAtLoc(nuggetID, 0, 0.5, 0.5, 1.5*cNumberNonGaiaPlayers);	
	
/*----------------------------------------------------------------------------------------------------------------*/

        // THE SOUTHERN NUGGETS:
		int nugget2ID= rmCreateObjectDef("The Nugget 2"); 
	    rmAddObjectDefItem(nugget2ID, "Nugget", 1, 0.0);
	    rmSetObjectDefMinDistance(nugget2ID, 0.0);
	    rmSetObjectDefMaxDistance(nugget2ID, rmXFractionToMeters(0.5));
	    
		rmAddObjectDefConstraint(nugget2ID, avoidImpassableLand);
  	    rmAddObjectDefConstraint(nugget2ID, avoidVeryFarNugget);
  	    rmAddObjectDefConstraint(nugget2ID, Southward);
		rmAddObjectDefConstraint(nugget2ID, playerEdgeConstraint);
  	    rmAddObjectDefConstraint(nugget2ID, avoidAll);
		rmAddObjectDefConstraint(nugget2ID, avoidCloseNatives);
		rmAddObjectDefConstraint(nugget2ID, avoidCloseTradeRoute);
		rmAddObjectDefConstraint(nugget2ID, avoidCloseSocket);
		rmAddObjectDefConstraint(nugget2ID, avoidForest);
  	    rmAddObjectDefConstraint(nugget2ID, avoidWater15);
	    rmAddObjectDefConstraint(nugget2ID, playerConstraint);
		    
		rmSetNuggetDifficulty(1, 2);
		if (cNumberNonGaiaPlayers<=2)
		rmPlaceObjectDefAtLoc(nugget2ID, 0, 0.5, 0.5, 3*cNumberNonGaiaPlayers);
		else
		rmPlaceObjectDefAtLoc(nugget2ID, 0, 0.5, 0.5, 1.5*cNumberNonGaiaPlayers);
		
/*===============================================================================================================*/
   // TEXT:
   // THESE STATUS TEXT LINES ARE USED TO MANUALLY ANIMATE THE MAP GENERATION PROGRESS BAR:
   rmSetStatusText("",0.75);
/*================================================================================================================*/   
// ************************************* DEFINE AND PLACE THE SILVER MINES: ************************************* //
/*================================================================================================================*/
// NONE FOR NOW:
/*----------------------------------------------------------------------------------------------------------------*/

        // THE NORTHERN SILVER MINES:
		int silverID = rmCreateObjectDef("silver north");
		
		if ( whichVariation == 1 )
	{	
		rmAddObjectDefItem(silverID, "mine", 1, 0);
	}
        else
    {
        rmAddObjectDefItem(silverID, "minegold", 1, 0);
    }	
	    
        rmSetObjectDefMinDistance(silverID, 0.0);
        rmSetObjectDefMaxDistance(silverID, rmXFractionToMeters(0.5));
	    
		rmAddObjectDefConstraint(silverID, avoidVeryFarCoin);
        rmAddObjectDefConstraint(silverID, avoidAll);
		rmAddObjectDefConstraint(silverID, avoidNugget);
		rmAddObjectDefConstraint(silverID, avoidWater12);
        rmAddObjectDefConstraint(silverID, avoidCloseSocket);
	    rmAddObjectDefConstraint(silverID, avoidCloseTradeRoute);
	    rmAddObjectDefConstraint(silverID, avoidCloseNatives);
        rmAddObjectDefConstraint(silverID, avoidCloseImpassableLand);
	    rmAddObjectDefConstraint(silverID, playerCloseConstraint);
	    rmAddObjectDefConstraint(silverID, playerEdgeConstraint);
	    rmAddObjectDefConstraint(silverID, Northward);
		
		if (cNumberNonGaiaPlayers<=2)
		rmPlaceObjectDefAtLoc(silverID, 0, 0.5, 0.5, 3*cNumberNonGaiaPlayers);
		else
		rmPlaceObjectDefAtLoc(silverID, 0, 0.5, 0.5, 1.5*cNumberNonGaiaPlayers);	
		
/*----------------------------------------------------------------------------------------------------------------*/

        // THE SOUTHERN SILVER MINES:
		int silver2ID = rmCreateObjectDef("silver south");
		
		if ( whichVariation == 1 )
	{	
		rmAddObjectDefItem(silver2ID, "mine", 1, 0);
	}
        else
    {
        rmAddObjectDefItem(silver2ID, "minegold", 1, 0);
    }	
	    
        rmSetObjectDefMinDistance(silver2ID, 0.0);
        rmSetObjectDefMaxDistance(silver2ID, rmXFractionToMeters(0.5));
	    
		
	    rmAddObjectDefConstraint(silver2ID, avoidVeryFarCoin);
        rmAddObjectDefConstraint(silver2ID, avoidAll);
		rmAddObjectDefConstraint(silver2ID, avoidNugget);
		rmAddObjectDefConstraint(silver2ID, avoidWater12);
        rmAddObjectDefConstraint(silver2ID, avoidCloseSocket);
	    rmAddObjectDefConstraint(silver2ID, avoidCloseTradeRoute);
	    rmAddObjectDefConstraint(silver2ID, avoidCloseNatives);
        rmAddObjectDefConstraint(silver2ID, avoidCloseImpassableLand);
	    rmAddObjectDefConstraint(silver2ID, playerCloseConstraint);
	    rmAddObjectDefConstraint(silver2ID, playerEdgeConstraint);
	    rmAddObjectDefConstraint(silver2ID, Southward);
		
		if (cNumberNonGaiaPlayers<=2)
		rmPlaceObjectDefAtLoc(silver2ID, 0, 0.5, 0.5, 3*cNumberNonGaiaPlayers);
		else
		rmPlaceObjectDefAtLoc(silver2ID, 0, 0.5, 0.5, 1.5*cNumberNonGaiaPlayers);
		
/*===============================================================================================================*/
   // TEXT:
   // THESE STATUS TEXT LINES ARE USED TO MANUALLY ANIMATE THE MAP GENERATION PROGRESS BAR:
   rmSetStatusText("",0.80);
/*================================================================================================================*/   
// ************************************* DEFINE AND PLACE THE DEER HERDS: *************************************** //
/*================================================================================================================*/

        // THE NORTHERN DEER HERDS:
		int deer1ID=rmCreateObjectDef("The Deer herds 1");
	    
		int bonusChance=rmRandFloat(0, 1);
	    if(bonusChance<0.5)   
		rmAddObjectDefItem(deer1ID, "deer", rmRandInt(4,6), 10.0);
	    else
		rmAddObjectDefItem(deer1ID, "deer", rmRandInt(8,10), 10.0);
	    
		rmSetObjectDefMinDistance(deer1ID, 0.0);
	    rmSetObjectDefMaxDistance(deer1ID, rmXFractionToMeters(0.5));
	    
		rmAddObjectDefConstraint(deer1ID, avoidAll);
		rmAddObjectDefConstraint(deer1ID, avoidNatives);
		rmAddObjectDefConstraint(deer1ID, playerEdgeConstraint);
		rmAddObjectDefConstraint(deer1ID, avoidImportantItem);
		rmAddObjectDefConstraint(deer1ID, avoidCloseNugget);
		rmAddObjectDefConstraint(deer1ID, avoidMediumCoin);
		rmAddObjectDefConstraint(deer1ID, Northward);
		rmAddObjectDefConstraint(deer1ID, avoidFruits);
		rmAddObjectDefConstraint(deer1ID, playerConstraint);
	    rmAddObjectDefConstraint(deer1ID, avoidVeryFarDeer);
	    rmAddObjectDefConstraint(deer1ID, avoidImpassableLand);
		rmAddObjectDefConstraint(deer1ID, avoidWater12);
		rmAddObjectDefConstraint(deer1ID, avoidTradeRoute);
		rmAddObjectDefConstraint(deer1ID, avoidSocket);
		rmAddObjectDefConstraint(deer1ID, avoidCloseForest);
	    
	    rmSetObjectDefCreateHerd(deer1ID, true);
		if (cNumberNonGaiaPlayers<=2)
		rmPlaceObjectDefAtLoc(deer1ID, 0, 0.5, 0.5, 3*cNumberNonGaiaPlayers);
		else
		rmPlaceObjectDefAtLoc(deer1ID, 0, 0.5, 0.5, 1.5*cNumberNonGaiaPlayers);	
		
	    
		
/*================================================================================================================*/

        // THE SOUTHERN DEER HERDS:
		int deer2ID=rmCreateObjectDef("The Deer herds 2");
	    
		bonusChance=rmRandFloat(0, 1);
	    if(bonusChance<0.5)   
		rmAddObjectDefItem(deer2ID, "deer", rmRandInt(4,6), 10.0);
	    else
		rmAddObjectDefItem(deer2ID, "deer", rmRandInt(8,10), 10.0);
	    
		rmSetObjectDefMinDistance(deer2ID, 0.0);
	    rmSetObjectDefMaxDistance(deer2ID, rmXFractionToMeters(0.5));
	    
		rmAddObjectDefConstraint(deer2ID, avoidAll);
		rmAddObjectDefConstraint(deer2ID, avoidNatives);
		rmAddObjectDefConstraint(deer2ID, playerEdgeConstraint);
		rmAddObjectDefConstraint(deer2ID, avoidImportantItem);
		rmAddObjectDefConstraint(deer2ID, avoidMediumCoin);
		rmAddObjectDefConstraint(deer2ID, avoidCloseNugget);
		rmAddObjectDefConstraint(deer2ID, Southward);
		rmAddObjectDefConstraint(deer2ID, avoidFruits);
		rmAddObjectDefConstraint(deer2ID, playerConstraint);
	    rmAddObjectDefConstraint(deer2ID, avoidVeryFarDeer);
	    rmAddObjectDefConstraint(deer2ID, avoidImpassableLand);
		rmAddObjectDefConstraint(deer2ID, avoidWater12);
		rmAddObjectDefConstraint(deer2ID, avoidTradeRoute);
		rmAddObjectDefConstraint(deer2ID, avoidSocket);
		rmAddObjectDefConstraint(deer2ID, avoidCloseForest);
	    
	    rmSetObjectDefCreateHerd(deer2ID, true);
		if (cNumberNonGaiaPlayers<=2)
		rmPlaceObjectDefAtLoc(deer2ID, 0, 0.5, 0.5, 3*cNumberNonGaiaPlayers);
		else
		rmPlaceObjectDefAtLoc(deer2ID, 0, 0.5, 0.5, 1.5*cNumberNonGaiaPlayers);
		
/*================================================================================================================*/
   // TEXT:
   // THESE STATUS TEXT LINES ARE USED TO MANUALLY ANIMATE THE MAP GENERATION PROGRESS BAR:
   rmSetStatusText("",0.85);
/*================================================================================================================*/
/*================================================================================================================*/
// ********************************** DEFINE AND PLACE THE SHEEP HERDS: **************************************** //
/*================================================================================================================*/

        // THE NORTHERN SHEEP HERDS:
		int sheep1ID=rmCreateObjectDef("The Sheep herds 1");
	    
		bonusChance=rmRandFloat(0, 1);
	    if(bonusChance<0.5)   
		rmAddObjectDefItem(sheep1ID, "sheep", rmRandInt(2,3), 4.0);
	    else
		rmAddObjectDefItem(sheep1ID, "sheep", rmRandInt(4,6), 6.0);
	    
		rmSetObjectDefMinDistance(sheep1ID, 0.0);
	    rmSetObjectDefMaxDistance(sheep1ID, rmXFractionToMeters(0.5));
	    
		rmAddObjectDefConstraint(sheep1ID, avoidAll);
		rmAddObjectDefConstraint(sheep1ID, avoidDeer);
	    rmAddObjectDefConstraint(sheep1ID, playerEdgeConstraint);
		rmAddObjectDefConstraint(sheep1ID, playerCloseConstraint);
		rmAddObjectDefConstraint(sheep1ID, Northward);
		rmAddObjectDefConstraint(sheep1ID, avoidCloseForest);
		rmAddObjectDefConstraint(sheep1ID, avoidCloseTradeRoute);
		rmAddObjectDefConstraint(sheep1ID, avoidCloseSocket);
		rmAddObjectDefConstraint(sheep1ID, avoidCloseNugget);
		rmAddObjectDefConstraint(sheep1ID, avoidCloseCoin);
		rmAddObjectDefConstraint(sheep1ID, avoidFruits);
		rmAddObjectDefConstraint(sheep1ID, avoidVeryFarSheep);
	    rmAddObjectDefConstraint(sheep1ID, avoidImpassableLand);
		rmAddObjectDefConstraint(sheep1ID, avoidWater12);
	    
	    rmSetObjectDefCreateHerd(sheep1ID, true);
		if (cNumberNonGaiaPlayers<=2)
		rmPlaceObjectDefAtLoc(sheep1ID, 0, 0.5, 0.5, cNumberNonGaiaPlayers*3.0);
		else
		rmPlaceObjectDefAtLoc(sheep1ID, 0, 0.5, 0.5, cNumberNonGaiaPlayers*1.5);
		
/*----------------------------------------------------------------------------------------------------------------*/

        // THE SOUTHERN SHEEP HERDS:
		int sheep2ID=rmCreateObjectDef("The Sheep herds 2");
	    
		bonusChance=rmRandFloat(0, 1);
	    if(bonusChance<0.5)   
		rmAddObjectDefItem(sheep2ID, "sheep", rmRandInt(2,3), 4.0);
	    else
		rmAddObjectDefItem(sheep2ID, "sheep", rmRandInt(4,6), 6.0);
	    
		rmSetObjectDefMinDistance(sheep2ID, 0.0);
	    rmSetObjectDefMaxDistance(sheep2ID, rmXFractionToMeters(0.5));
	    
		rmAddObjectDefConstraint(sheep2ID, avoidAll);
		rmAddObjectDefConstraint(sheep2ID, avoidDeer);
	    rmAddObjectDefConstraint(sheep2ID, playerEdgeConstraint);
		rmAddObjectDefConstraint(sheep2ID, playerCloseConstraint);
		rmAddObjectDefConstraint(sheep2ID, Southward);
		rmAddObjectDefConstraint(sheep2ID, avoidCloseForest);
		rmAddObjectDefConstraint(sheep2ID, avoidCloseTradeRoute);
		rmAddObjectDefConstraint(sheep2ID, avoidCloseSocket);
		rmAddObjectDefConstraint(sheep2ID, avoidCloseNugget);
		rmAddObjectDefConstraint(sheep2ID, avoidCloseCoin);
		rmAddObjectDefConstraint(sheep2ID, avoidFruits);
		rmAddObjectDefConstraint(sheep2ID, avoidVeryFarSheep);
	    rmAddObjectDefConstraint(sheep2ID, avoidImpassableLand);
		rmAddObjectDefConstraint(sheep2ID, avoidWater15);
	    
	    rmSetObjectDefCreateHerd(sheep2ID, true);
		if (cNumberNonGaiaPlayers<=2)
		rmPlaceObjectDefAtLoc(sheep2ID, 0, 0.5, 0.5, cNumberNonGaiaPlayers*3.0);
		else
		rmPlaceObjectDefAtLoc(sheep2ID, 0, 0.5, 0.5, cNumberNonGaiaPlayers*1.5);
		
/*===============================================================================================================*/
   // TEXT:
   // THESE STATUS TEXT LINES ARE USED TO MANUALLY ANIMATE THE MAP GENERATION PROGRESS BAR:
   rmSetStatusText("",0.90);
/*================================================================================================================*/
// ************************** DEFINE AND PLACE SOME RANDOM NORTHERN AND SOUTHERN CLIFFS: ************************ //
/*================================================================================================================*/

		numTries = -1;
	    failCount = -1;
		
		if (cNumberNonGaiaPlayers<=2)
		numTries=cNumberNonGaiaPlayers*4;
		else
		numTries=cNumberNonGaiaPlayers*2;
	    failCount=0;
	    
		for(i=0; <numTries)
{	
		int Cliff1ID=rmCreateArea("The Cliff 1"+i);
	    rmSetAreaSize(Cliff1ID, 0.0015, 0.0015);
		rmSetAreaWarnFailure(Cliff1ID, false);
		rmSetAreaCliffType(Cliff1ID, "Amazon");
		rmAddAreaToClass(Cliff1ID, rmClassID("classCliff"));		
		//rmSetAreaCliffEdge(Cliff1ID, 1, 0.6, 0.1, 1.0, 0);
        rmSetAreaCliffEdge(Cliff1ID, 1, 1.0, 0.1, 1.0, 0);		
		rmSetAreaCliffPainting(Cliff1ID, true, true, true, 1.5, true);
		rmSetAreaCliffHeight(Cliff1ID, 6, 1.0, 1.0);
		rmSetAreaHeightBlend(Cliff1ID, 1.0);
		rmSetAreaMix(Cliff1ID, "yucatan_grass");
		//rmAddAreaTerrainLayer(Cliff1ID, "yucatan_grass", 0, 2);
        rmSetAreaSmoothDistance(Cliff1ID, 15);
		rmSetAreaCoherence(Cliff1ID, 0.85);
		
		rmAddAreaConstraint(Cliff1ID, avoidImportantItem);
		rmAddAreaConstraint(Cliff1ID, avoidCloseTradeRoute);
		rmAddAreaConstraint(Cliff1ID, avoidCloseSocket);
		rmAddAreaConstraint(Cliff1ID, playerEdgeConstraint);
		rmAddAreaConstraint(Cliff1ID, avoidImpassableLand);
		rmAddAreaConstraint(Cliff1ID, avoidAll);
		rmAddAreaConstraint(Cliff1ID, avoidWater12);
		rmAddAreaConstraint(Cliff1ID, avoidCloseDeer);
		rmAddAreaConstraint(Cliff1ID, avoidCloseSheep);
		rmAddAreaConstraint(Cliff1ID, avoidCloseCoin);
		rmAddAreaConstraint(Cliff1ID, avoidCloseNugget);
		rmAddAreaConstraint(Cliff1ID, avoidCloseForest);
		rmAddAreaConstraint(Cliff1ID, avoidVeryFarCliffs);
		rmAddAreaConstraint(Cliff1ID, Northward);
		rmAddAreaConstraint(Cliff1ID, playerCloseConstraint);
	
		if(rmBuildArea(Cliff1ID)==false)
		{
			// Stop trying once we fail 3 times in a row
			failCount++;
			if(failCount==3)
				break;
		}
		else
			failCount=0;
	}
	
/*----------------------------------------------------------------------------------------------------------------*/		

		for(i=0; <numTries)
	{	
		int Cliff2ID=rmCreateArea("The Cliff 2"+i);
	    rmSetAreaSize(Cliff2ID, 0.0015, 0.0015);
		rmSetAreaWarnFailure(Cliff2ID, false);
		rmSetAreaCliffType(Cliff2ID, "Amazon");
		rmAddAreaToClass(Cliff2ID, rmClassID("classCliff"));		
		//rmSetAreaCliffEdge(Cliff2ID, 1, 0.6, 0.1, 1.0, 0);
        rmSetAreaCliffEdge(Cliff2ID, 1, 1.0, 0.1, 1.0, 0);			
		rmSetAreaCliffPainting(Cliff2ID, true, true, true, 1.5, true);
		rmSetAreaCliffHeight(Cliff2ID, 6, 1.0, 1.0);
		rmSetAreaHeightBlend(Cliff2ID, 1.0);
		rmSetAreaMix(Cliff2ID, "yucatan_grass");
		//rmAddAreaTerrainLayer(Cliff2ID, "texas\ground2_tex", 0, 2);
        rmSetAreaSmoothDistance(Cliff2ID, 15);
		rmSetAreaCoherence(Cliff2ID, 0.85);
		
		rmAddAreaConstraint(Cliff2ID, avoidImportantItem);
		rmAddAreaConstraint(Cliff2ID, avoidCloseTradeRoute);
		rmAddAreaConstraint(Cliff2ID, avoidCloseSocket);
		rmAddAreaConstraint(Cliff2ID, playerEdgeConstraint);
		rmAddAreaConstraint(Cliff2ID, avoidImpassableLand);
		rmAddAreaConstraint(Cliff2ID, avoidAll);
		rmAddAreaConstraint(Cliff2ID, avoidWater12);
		rmAddAreaConstraint(Cliff2ID, avoidCloseDeer);
		rmAddAreaConstraint(Cliff2ID, avoidCloseSheep);
		rmAddAreaConstraint(Cliff2ID, avoidCloseCoin);
		rmAddAreaConstraint(Cliff2ID, avoidCloseNugget);
		rmAddAreaConstraint(Cliff2ID, avoidCloseForest);
		rmAddAreaConstraint(Cliff2ID, avoidVeryFarCliffs);
		rmAddAreaConstraint(Cliff2ID, Southward);
		rmAddAreaConstraint(Cliff2ID, playerCloseConstraint);
				
		if(rmBuildArea(Cliff2ID)==false)
		{
			// Stop trying once we fail 3 times in a row
			failCount++;
			if(failCount==3)
				break;
		}
		else
			failCount=0;
		
	}		
/*===============================================================================================================*/
   // TEXT:
   // THESE STATUS TEXT LINES ARE USED TO MANUALLY ANIMATE THE MAP GENERATION PROGRESS BAR:
   rmSetStatusText("",0.925);
/*================================================================================================================*/   
// ************************************ DEFINE AND PLACE THE WOOD RESOURCES: ************************************ //
/*================================================================================================================*/
// NONE FOR NOW:
/*----------------------------------------------------------------------------------------------------------------*/

        // RANDOM TREES FOR THE 2 ISLANDS:
		int randomTreeID=rmCreateObjectDef("The Random Trees");
		rmAddObjectDefItem(randomTreeID, "TreeAmazon", 1, 0.0);
		rmAddObjectDefToClass(randomTreeID, rmClassID("classTrees"));
		rmSetObjectDefMinDistance(randomTreeID, 0.0);
        rmSetObjectDefMaxDistance(randomTreeID, rmXFractionToMeters(0.5));
		
		rmAddObjectDefConstraint(randomTreeID, playerEdgeConstraint); 
	    rmAddObjectDefConstraint(randomTreeID, avoidCloseTradeRoute);
		rmAddObjectDefConstraint(randomTreeID, avoidCloseSocket);
		rmAddObjectDefConstraint(randomTreeID, avoidAll);
		rmAddObjectDefConstraint(randomTreeID, avoidCloseCliffs);
		rmAddObjectDefConstraint(randomTreeID, avoidCloseForest);
		rmAddObjectDefConstraint(randomTreeID, avoidNatives);
		rmAddObjectDefConstraint(randomTreeID, avoidCloseDeer);
		rmAddObjectDefConstraint(randomTreeID, avoidCloseSheep);
		rmAddObjectDefConstraint(randomTreeID, avoidWater12);
		rmAddObjectDefConstraint(randomTreeID, avoidImpassableLand);
		rmAddObjectDefConstraint(randomTreeID, playerCloseConstraint);
		rmAddObjectDefConstraint(randomTreeID, avoidCloseTrees);
		rmAddObjectDefConstraint(randomTreeID, avoidCloseCoin);
		rmAddObjectDefConstraint(randomTreeID, avoidCloseNugget);
			    	
		if (cNumberNonGaiaPlayers<=2)
		rmPlaceObjectDefAtLoc(randomTreeID, 0, 0.5, 0.5, 60*cNumberNonGaiaPlayers);
		else
		rmPlaceObjectDefAtLoc(randomTreeID, 0, 0.5, 0.5, 15*cNumberNonGaiaPlayers);
		
/*===============================================================================================================*/
   // TEXT:
   // THESE STATUS TEXT LINES ARE USED TO MANUALLY ANIMATE THE MAP GENERATION PROGRESS BAR:
   rmSetStatusText("",0.95);
/*================================================================================================================*/   
// ************************************** DEFINE AND PLACE THE BERRYBUSH: *************************************** //		
/*================================================================================================================*/

        // THE NORTHERN BERRYBUSH:
		int BerriesID=rmCreateObjectDef("The Berries 1");
        rmAddObjectDefItem(BerriesID, "berrybush", rmRandInt(3,7), 8.0);
        rmSetObjectDefMinDistance(BerriesID, 0.0);
        rmSetObjectDefMaxDistance(BerriesID, rmXFractionToMeters(0.5));
		
		rmAddObjectDefConstraint(BerriesID, avoidVeryFarFruits);
		rmAddObjectDefConstraint(BerriesID, Northward);
        rmAddObjectDefConstraint(BerriesID, avoidAll);
		rmAddObjectDefConstraint(BerriesID, avoidCloseNatives);
		rmAddObjectDefConstraint(BerriesID, avoidMediumDeer);
		rmAddObjectDefConstraint(BerriesID, avoidCloseForest);
		rmAddObjectDefConstraint(BerriesID, playerCloseConstraint);
		rmAddObjectDefConstraint(BerriesID, avoidCloseCoin);
		rmAddObjectDefConstraint(BerriesID, avoidNugget);
		rmAddObjectDefConstraint(BerriesID, avoidCloseSocket);
		rmAddObjectDefConstraint(BerriesID, avoidCloseTradeRoute);
		rmAddObjectDefConstraint(BerriesID, avoidImpassableLand);
		rmAddObjectDefConstraint(BerriesID, playerEdgeConstraint);
		rmAddObjectDefConstraint(BerriesID, avoidImportantItem);
		rmAddObjectDefConstraint(BerriesID, avoidWater15);
		rmAddObjectDefConstraint(BerriesID, avoidCloseCliffs);
		        
		rmSetObjectDefCreateHerd(BerriesID, true);
		if (cNumberNonGaiaPlayers<=2)
		rmPlaceObjectDefAtLoc(BerriesID, 0, 0.5, 0.5, cNumberNonGaiaPlayers*3.0);
		else
		rmPlaceObjectDefAtLoc(BerriesID, 0, 0.5, 0.5, cNumberNonGaiaPlayers*1.5);
		
/*----------------------------------------------------------------------------------------------------------------*/

        // THE SOUTHERN BERRYBUSH:
		int Berries2ID=rmCreateObjectDef("The Berries 2");
        rmAddObjectDefItem(Berries2ID, "berrybush", rmRandInt(3,7), 8.0);
        rmSetObjectDefMinDistance(Berries2ID, 0.0);
        rmSetObjectDefMaxDistance(Berries2ID, rmXFractionToMeters(0.5));
		
		rmAddObjectDefConstraint(Berries2ID, avoidVeryFarFruits);
		rmAddObjectDefConstraint(Berries2ID, Southward);
        rmAddObjectDefConstraint(Berries2ID, avoidAll);
		rmAddObjectDefConstraint(Berries2ID, avoidCloseNatives);
		rmAddObjectDefConstraint(Berries2ID, avoidMediumDeer);
		rmAddObjectDefConstraint(Berries2ID, avoidCloseForest);
		rmAddObjectDefConstraint(Berries2ID, playerCloseConstraint);
		rmAddObjectDefConstraint(Berries2ID, avoidCloseCoin);
		rmAddObjectDefConstraint(Berries2ID, avoidNugget);
		rmAddObjectDefConstraint(Berries2ID, avoidCloseSocket);
		rmAddObjectDefConstraint(Berries2ID, avoidCloseTradeRoute);
		rmAddObjectDefConstraint(Berries2ID, avoidImpassableLand);
		rmAddObjectDefConstraint(Berries2ID, playerEdgeConstraint);
		rmAddObjectDefConstraint(Berries2ID, avoidImportantItem);
		rmAddObjectDefConstraint(Berries2ID, avoidWater15);
		rmAddObjectDefConstraint(Berries2ID, avoidCloseCliffs);
		        
		rmSetObjectDefCreateHerd(Berries2ID, true);
		if (cNumberNonGaiaPlayers<=2)
		rmPlaceObjectDefAtLoc(Berries2ID, 0, 0.5, 0.5, cNumberNonGaiaPlayers*3.0);
		else
		rmPlaceObjectDefAtLoc(Berries2ID, 0, 0.5, 0.5, cNumberNonGaiaPlayers*1.5);
		
/*================================================================================================================*/
   // TEXT:
   // THESE STATUS TEXT LINES ARE USED TO MANUALLY ANIMATE THE MAP GENERATION PROGRESS BAR:
   rmSetStatusText("",0.99);
/*================================================================================================================*/

        int fishID=rmCreateObjectDef("fish");
        rmAddObjectDefItem(fishID, "FishBass", 3, 9.0);
        rmSetObjectDefMinDistance(fishID, 0.0);
        rmSetObjectDefMaxDistance(fishID, rmXFractionToMeters(0.5));
        rmAddObjectDefConstraint(fishID, fishVsFishID);
        rmAddObjectDefConstraint(fishID, fishLand);
		
		if (cNumberNonGaiaPlayers<=2)
		rmPlaceObjectDefAtLoc(fishID, 0, 0.5, 0.5, 10*cNumberNonGaiaPlayers);
		else
		rmPlaceObjectDefAtLoc(fishID, 0, 0.5, 0.5, 5*cNumberNonGaiaPlayers);

/*===============================================================================================================*/
   // TEXT:
   // THESE STATUS TEXT LINES ARE USED TO MANUALLY ANIMATE THE MAP GENERATION PROGRESS BAR:
   rmSetStatusText("",1.00);
/*===============================================================================================================*/
}
/*===============================================================================================================*/
// ************************************** THIS IS THE END OF THE MAP: ****************************************** //
/*===============================================================================================================*/		









      